//Metric Garden plants.

#declare Lens_With_Hole = difference {
  intersection {
    sphere { <0, 0, 0>, 1
      translate -0.5*x
    }
    sphere { <0, 0, 0>, 1
      translate 0.5*x
    }
    rotate 90*y
  }
  cylinder { <0, 0, -1> <0, 0, 1> .35 }
}

#declare Buncha_Lenses = merge {
  object { Lens_With_Hole translate <-.65, .65, 0> }
  object { Lens_With_Hole translate <.65, .65, 0> }
  object { Lens_With_Hole translate <-.65, -.65, 0> }
  object { Lens_With_Hole translate <.65, -.65, 0> }
  pigment { Red filter .5 }
}                             

#declare Bug_Sparkle = difference {
  box { -1, 1 pigment { Red filter .9 } }
  cylinder { -z, z, 0.5 pigment { Green } }
}

#declare CenterOfTheUniverse = difference {
  sphere {
    <0, 1, 2>, 2
    texture {
      pigment { color Yellow }
    }
  }

  box {
    <-1, 0, -1>,
    < 1, 0.5, 3>
    texture {
      T_Stone25
      scale 4
    }
    rotate y*20
  }

  cone {
    <0, 1, 0>, 0.3
    <1, 2, 3>, 1.0
    open
    texture { T_Stone25 scale 4 }
  }

  cylinder {
    <0, 1, 0>,
    <1, 2, 3>,
    0.5
    open
    texture { T_Stone25 scale 4 }
  }

  object { Buncha_Lenses rotate z*45 rotate y*20 }
  object { Bug_Sparkle }
}

#declare EggTex = texture {
  pigment { BrightGold }
  finish {
    ambient .1
    diffuse .4
    specular 1
    roughness 0.001
    reflection .5
    metallic
  }
}
 


#declare TeePeeTex = texture {
    pigment { Silver }
    finish {
      ambient .1
      diffuse .4
      specular 1
      roughness 0.001
      reflection .5
      metallic
    }
  }


#declare TeePee = 
 bicubic_patch {
    type 1 flatness 0.0100 u_steps 3 v_steps 3,
    <-5.174134, 5.528420, -13.211995>,
    <-1.769023, 5.528420, 0.000000>,
    <1.636088, 5.528420, 0.000000>,
    <5.041199, 5.528420, -13.003932>,
    <-5.174134, 1.862827, 0.000000>,
    <0.038471, 0.031270, 18.101474>,
    <0.036657, 0.031270, 18.101474>,
    <5.041199, 1.862827, 0.000000>,
    <-5.174134, -1.802766, 0.000000>,
    <0.038471, 0.028792, 18.101474>,
    <0.036657, 0.028792, 18.101474>,
    <5.041199, -1.802766, 0.000000>,
    <-5.174134, -5.468359, -13.070366>,
    <-1.769023, -5.468359, 0.000000>,
    <1.636088, -5.468359, 0.000000>,
    <4.974128, -5.468359, -12.801446>
    texture {
      TeePeeTex
    }
    rotate -90*x  // to orient the object to LHC
    rotate 25*y   // to see the four "legs" better
  }

#declare Egg = union { // Egg1
  bicubic_patch {
    type 1 flatness 0.0100 u_steps 4 v_steps 4,
    <2.023314, 0.000000, 4.355987>,
    <2.023314, -0.000726, 4.355987>,
    <2.023312, -0.000726, 4.356867>,
    <2.023312, 0.000000, 4.356867>,
    <2.032037, 0.000000, 2.734598>,
    <2.032037, -1.758562, 2.734598>,
    <2.027431, -1.758562, 6.141971>,
    <2.027431, 0.000000, 6.141971>,
    <-1.045672, 0.000000, 3.281572>,
    <-1.045672, -1.758562, 3.281572>,
    <-1.050279, -1.758562, 5.414183>,
    <-1.050279, 0.000000, 5.414183>,
    <-1.044333, 0.000000, 4.341816>,
    <-1.044333, -0.002947, 4.341816>,
    <-1.044341, -0.002947, 4.345389>,
    <-1.044341, 0.000000, 4.345389>
  }
  bicubic_patch {
    type 1 flatness 0.0100 u_steps 4 v_steps 4,
    <2.023312, 0.000000, 4.356867>,
    <2.023312, 0.000726, 4.356867>,
    <2.023314, 0.000726, 4.355987>,
    <2.023314, 0.000000, 4.355987>,
    <2.027431, 0.000000, 6.141971>,
    <2.027431, 1.758562, 6.141971>,
    <2.032037, 1.758562, 2.734598>,
    <2.032037, 0.000000, 2.734598>,
    <-1.050279, 0.000000, 5.414183>,
    <-1.050279, 1.758562, 5.414183>,
    <-1.045672, 1.758562, 3.281572>,
    <-1.045672, 0.000000, 3.281572>,
    <-1.044341, 0.000000, 4.345389>,
    <-1.044341, 0.002947, 4.345389>,
    <-1.044333, 0.002947, 4.341816>,
    <-1.044333, 0.000000, 4.341816>
  }
  texture { EggTex }
  translate <0.5, 0, -5>  // centers the egg around the origin
  translate -9.8*y        // places the egg on the ground
}
  
#declare TeePeeFarm = union {
  object { TeePee }
  object { TeePee translate <8, 0, 8> }
  object { TeePee translate <-9, 0, 9> }
  object { TeePee translate <18, 0, 24> }
  object { TeePee translate <-18, 0, 24> }
  object { Egg }
  object { Egg translate <8, 0, 8> }
  object { Egg translate <-9, 0, 9> }
  object { Egg translate <18, 0, 24> }
  object { Egg translate <-18, 0, 24> }
}

#declare TheDaySky = plane {
  y, 500
  texture {
    pigment { SkyBlue filter crick transmit .1 }
    finish { ambient 1 diffuse 0}
  }
  texture {
    pigment {
      bozo
      turbulence .5
      color_map {
        [0 White filter crick * .8]
        [1 White filter 1]
      }
    }
    finish { ambient 1 diffuse 0 }
    scale <1000, 250, 250>
    rotate <5, 180 * clock, 0>
    }
    hollow
}

#declare SandDunes = plane {
  y, -12
  texture {
    pigment {
      color <.85, .6, .25>
    }
    finish {
      ambient .5 - crick / 4
      diffuse .6
    }
    normal {
      ripples .35
      turbulence .25
      frequency 5
    }
    scale 10
    scale y*3          
    translate 50*x
    }
    hollow

}

#declare Dual_Blob = union {
  blob {
    threshold .65
    sphere { <.5,0,0>, .8, 1 pigment {Blue} }
    sphere { <-.5,0,0>,.8, 1 pigment {Pink} }
    finish { phong 1 ambient .6 }
  }
  sphere { <.5,0,0>, .8
    pigment { Yellow transmit .75 }
  }
  sphere { <-.5,0,0>, .8
    pigment { Green transmit .75 }
  }
  blob {
    threshold .65
    cylinder { <-.75,-.75,0>, <.75,.75,0>, .5, 1 }
    pigment { Blue }
    finish { phong 1 }
  translate y*-1
  }
}

#declare HandOne = blob {
  threshold .65
  sphere { <-.23,-.32,0>,.43, 1 scale <1.95,1.05,.8> }   //palm
  sphere { <+.12,-.41,0>,.43, 1 scale <1.95,1.075,.8> }  //palm
  sphere { <-.23,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
  sphere { <+.19,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
  sphere { <-.22,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
  sphere { <+.19,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
  cylinder { <-.65,-.28,0>, <-.65,.28,-.05>, .26, 1 }    //lower pinky
  cylinder { <-.65,.28,-.05>, <-.65, .68,-.2>, .26, 1 }  //upper pinky
  cylinder { <-.3,-.28,0>, <-.3,.44,-.05>, .26, 1 }      //lower ring
  cylinder { <-.3,.44,-.05>, <-.3, .9,-.2>, .26, 1 }     //upper ring
  cylinder { <.05,-.28,0>, <.05, .49,-.05>, .26, 1 }     //lower middle
  cylinder { <.05,.49,-.05>, <.05, .95,-.2>, .26, 1 }    //upper middle
  cylinder { <.4,-.4,0>, <.4, .512, -.05>, .26, 1 }      //lower index
  cylinder { <.4,.512,-.05>, <.4, .85, -.2>, .26, 1 }    //upper index
  cylinder { <.41, -.95,0>, <.85, -.68, -.05>, .25, 1 }  //lower thumb
  cylinder { <.85,-.68,-.05>, <1.2, -.4, -.2>, .25, 1 }  //upper thumb
  sphere { <-.65,.28,-.05>, .26, -1 } //counteract pinky knuckle bulge
  sphere { <-.65,-.28,0>, .26, -1 }   //counteract pinky palm bulge
  sphere { <-.3,.44,-.05>, .26, -1 }  //counteract ring knuckle bulge
  sphere { <-.3,-.28,0>, .26, -1 }    //counteract ring palm bulge
  sphere { <.05,.49,-.05>, .26, -1 }  //counteract middle knuckle bulge
  sphere { <.05,-.28,0>, .26, -1 }    //counteract middle palm bulge
  sphere { <.4,.512,-.05>, .26, -1 }  //counteract index knuckle bulge
  sphere { <.4,-.4,0>, .26, -1 }      //counteract index palm bulge
  sphere { <.85,-.68,-.05>, .25, -1 } //counteract thumb knuckle bulge
  sphere { <.41,-.7,0>, .25, -.89 }   //counteract thumb heel bulge
  pigment { Flesh }
}

#declare BlueTop = lathe {
  linear_spline
  6,
  <0,0>, <1,1>, <3,2>, <2,3>, <2,4>, <0,4>
  pigment { Blue }
  finish {
    ambient .3
    phong .75
  }
}

#declare GreenPrism = union {
  prism {
      linear_sweep
      linear_spline
      0, // sweep the following shape from here ...
      1, // ... up through here
      7, // the number of points making up the shape ...
      <3,5>, <-3,5>, <-5,0>, <-3,-5>, <3, -5>, <5,0>, <3,5>
      pigment { Green }
  }
    prism {
    cubic_spline
    1, // sweep the following shape from here ...
    2, // ... up through here
    6, // the number of points making up the shape ...
    < 3, -5>, // point#1 (control point... not on curve)
    < 3,  5>, // point#2  ... THIS POINT ...
    <-5,  0>, // point#3
    < 3, -5>, // point#4
    < 3,  5>, // point#5 ... MUST MATCH THIS POINT
    <-5,  0>  // point#6 (control point... not on curve)
    pigment { Green filter .4 }
  }
   prism {
    linear_sweep
    cubic_spline
    2,  // sweep the following shape from here ...
    3,  // ... up through here
    18, // the number of points making up the shape ...
    <3,-5>, <3,5>, <-5,0>, <3, -5>, <3,5>, <-5,0>, // sub-shape #1
    <2,-4>, <2,4>, <-4,0>, <2,-4>, <2,4>, <-4,0>,  // sub-shape #2
    <1,-3>, <1,3>, <-3,0>, <1, -3>, <1,3>, <-3,0>  // sub-shape #3
    pigment { Green filter .7 }
  }
}

#declare GreyPyramid = union {
  prism {
    conic_sweep
    linear_spline
    .251, // height 1
    1, // height 2
    5, // the number of points making up the shape...
    <4,4>,<-4,4>,<-4,-4>,<4,-4>,<4,4>
    rotate <180, 0, 0>
    translate <0, 1, 0>
    scale <1, 4, 1>
    pigment { gradient y scale .2 }
  }
  superellipsoid { <.1, 1>
    pigment { Red }
    translate y*5
  }
}

#declare GoldenGoblet = sor {
    8,
    <0.0,  -0.5>,
    <3.0,   0.0>,
    <1.0,   0.2>,
    <0.5,   0.4>,
    <0.5,   4.0>,
    <1.0,   5.0>,
    <3.0,  10.0>,
    <4.0,  11.0>
    texture { T_Stone12 }
  }
  
#declare CentralSpotLight = union {
  light_source {
    <0, 17, 2>
    color Yellow
    spotlight
    radius 170
    falloff 120
    tightness 10
    point_at <0, 1, 2>
  }
  light_source {
    <2, 100, -3>
    color White
    area_light <50, 0, 0>, <0, 0, 50>, 5, 5
    adaptive 1
    jitter
  }
}

#declare PlantBox = union {
  box { <1, .1, 1>
        <-1, 0, -1>
    texture {
      pigment {
      bozo
      color_map {
      [0.00 color rgb<.65,.45,.25>]
      [0.33 color DarkBrown]
      [0.5 color rgb<.65,.45,.25>]
      [1.00 color Brown]
      }
    scale .2
    }

      normal { waves scale x*.5 scale y*4 }
    }
  }
  cone { <1, .2, 1>, .1
         <1, .2,-1>, .1
    texture { T_Stone12 }
    scale y*4 translate y*-.8
  }
  cone { <1, .2, -1>, .1
         <-1, .2,-1>, .1
    texture { T_Stone12 }
    scale y*4 translate y*-.8
  }
  cone { <-1, .2, -1>, .1
         <-1, .2,1>, .1
    texture { T_Stone12 }
    scale y*4 translate y*-.8
  }
  cone { <-1, .2, 1>, .1
         <1, .2, 1>, .1
    texture { T_Stone12 }
    scale y*4 translate y*-.8
  }
}

#declare Plant1 = union {
  cone { <0, .2, 0>, .09 <0, 3, 0>, .01
    pigment {
      wood
      color_map {
        [0.00 color Navy]
        [0.3 color DarkGreen]
        [0.7 color  Green]
        [1.00 color Black]
          }
    turbulence .5
    scale .1
    }
    finish { phong 1 metallic }
  }
  cone { <0, 0, 0>, .2 <0, .2, 0>, .09
    pigment {
      wood
      color_map {
        [0.00 color Navy]
        [0.3 color DarkGreen]
        [0.7 color  Green]
        [1.00 color Black]
          }
    turbulence .5
    scale .1
    }
    finish { phong 1 metallic }
  }
  cone { <0, 1.4, 0>, .08 <.5, 1.3, 0>, .02
    pigment {
      wood
      color_map {
        [0.00 color Navy]
        [0.3 color DarkGreen]
        [0.7 color  Green]
        [1.00 color Black]
          }
    turbulence .5
    scale .1
    }
    finish { phong 1 metallic }
  }
  cone { <.5, 1.3, 0>, .08 <.8, 1.9, .2>, 0
    pigment {
      wood
      color_map {
        [0.00 color Navy]
        [0.3 color DarkGreen]
        [0.7 color  Green]
        [1.00 color Black]
          }
    turbulence .5
    scale .1
    }
    finish { phong 1 metallic }
  }
  blob {
    threshold .006
    cylinder { <.8, 1.9, .2>, <.75,2,.1>, .07, .1 }
    cylinder { <.8, 1.9, .2>, <.85,2,.1>, .07, .1 }
    cylinder { <.8, 1.9, .2>, <.75,2,-.1>, .05, .1 }
    cylinder { <.8, 1.9, .2>, <.75,1.8,.1>, .07, .1 }
    cylinder { <.8, 1.9, .2>, <.85,2,-.1>, .05, .1 }
    cylinder { <.8, 1.9, .2>, <.85,1.8,-.1>, .06, .1 }
    cylinder { <.8, 1.9, .2>, <.85,2,.16>, .03, .1 }
    cylinder { <.8, 1.9, .2>, <.35,2,.16>, .03, .1 }
    cylinder { <.8, 1.9, .2>, <.45,2.1,-.1>, .03, .1 }
    cylinder { <.8, 1.9, .2>, <.75,1.8,.13>, .03, .1 }
    cylinder { <.8, 1.9, .2>, <.85,2.1,-.1>, .03, .1 }
    cylinder { <.8, 1.9, .2>, <.85,1.6,-.17>, .03, .1 }
    texture {
      pigment {
        bozo
        color_map {
        [0.0 color Blue ]
        [0.05 color Green ]
        [0.15 color Red ]
        [0.25 color Orange ]
        [0.35 color Blue ]
        [0.45 color Red ]
        [0.55 color rgb<1,.3,.1> ]
        [0.65 color White ]
        [0.75 color Navy ]
        [0.85 color Gold ]
        [0.95 color Silver ]
        [1.00 color Yellow ]
        }
        turbulence .3
      }
    finish { phong 0 }
  }

 }  
}

#declare PlantA = union {
  object { Plant1 }
  object { Plant1 rotate y*48 scale <.9,1.2,.9> }  
  object { Plant1 rotate y*98 scale <.8,1.4,.8> }
  object { Plant1 rotate y*138 scale <.7,1.6,.7> }  
  object { Plant1 rotate y*208 scale <.6,1.8,.6> }
  object { Plant1 rotate y*287 scale <.5,2,.5> }  
}

#declare PlantB = union {
  object { Plant1 }
  object { Plant1 rotate y*348 scale <.9,1.4,.9> }  
  object { Plant1 rotate y*38 scale <.8,1.4,.8> }
  object { Plant1 rotate y*238 scale <.7,1.9,.7> }  
  object { Plant1 rotate y*108 scale <.6,2.1,.6> }
  object { Plant1 rotate y*187 scale <.5,2.3,.5> }  
}

#declare PlantC = union {
  object { Plant1 }
  object { Plant1 rotate y*14 scale <.9,1.2,.9> }  
  object { Plant1 rotate y*94 scale <.8,1.4,.8> }
  object { Plant1 rotate y*18 scale <.7,1.6,.7> }  
  object { Plant1 rotate y*280 scale <.6,1.8,.6> }
  object { Plant1 rotate y*307 scale <.7,2.2,.7> }  
}

#declare PlantD = union {
  object { Plant1 }
  object { Plant1 rotate y*8 scale <.2,1.2,.9> }  
  object { Plant1 rotate y*198 scale <.8,1.4,.8> }
  object { Plant1 rotate y*38 scale <.7,1.6,.4> }  
  object { Plant1 rotate y*8 scale <.6,1.8,.6> }
  object { Plant1 rotate y*287 scale <.7,2,.5> }  
}

#declare PlantE = union {
  object { Plant1 }
  object { Plant1 rotate y*248 scale <.9,1.2,.9> }  
  object { Plant1 rotate y*198 scale <.8,1.4,.8> }
  object { Plant1 rotate y*238 scale <.7,1.6,.7> }  
  object { Plant1 rotate y*8 scale <.6,1.8,.6> }
  object { Plant1 rotate y*7 scale <.5,2,.5> }  
}
#declare PlantF = union {
  object { Plant1 }
  object { Plant1 rotate y*54 scale <.9,1.2,.9> }  
  object { Plant1 rotate y*24 scale <.8,1.4,.8> }
  object { Plant1 rotate y*158 scale <.7,1.6,.7> }  
  object { Plant1 rotate y*248 scale <.6,1.8,.6> }
  object { Plant1 rotate y*287 scale <.5,2,.5> }  
}

#declare PlantG = union {
  object { Plant1 }
  object { Plant1 rotate y*48 scale <.9,1.2,.9> }  
  object { Plant1 rotate y*98 scale <.8,1.4,.8> }
  object { Plant1 rotate y*138 scale <.7,1.6,.7> }  
  object { Plant1 rotate y*208 scale <.6,1.8,.6> }
  object { Plant1 rotate y*287 scale <.5,2,.5> }  
}

#declare PlantH = union {
  object { Plant1 }
  object { Plant1 rotate y*348 scale <.9,1.2,.9> }  
  object { Plant1 rotate y*98 scale <.8,1.4,.8> }
  object { Plant1 rotate y*138 scale <.7,1.6,.7> }  
  object { Plant1 rotate y*28 scale <.6,1.8,.6> }
  object { Plant1 rotate y*87 scale <.5,2,.5> }  
}

#declare PlantI = union {
  object { Plant1 }
  object { Plant1 rotate y*128 scale <.9,1.2,.9> }  
  object { Plant1 rotate y*300 scale <.8,1.4,.8> }
  object { Plant1 rotate y*13 scale <.7,1.6,.7> }  
  object { Plant1 rotate y*12 scale <.6,1.8,.6> }
  object { Plant1 rotate z*7 scale <.5,2,.5> }  
}

#declare PlantBoxArray1 = union {
  
  object { PlantBox translate <2,0,0> }
  object { PlantBox translate <2,0,2> }
  object { PlantBox translate <2,0,-2> }
  object { PlantBox translate <-2,0,0> }
  object { PlantBox translate <-2,0,2> }
  object { PlantBox translate <-2,0,-2> }
  object { PlantBox translate <0,0,2> }
  object { PlantBox translate <0,0,-2> }
  object { PlantBox translate <0,0,0> }

  object { PlantA translate <2,0,0> }
  object { PlantB translate <2,0,2> }
  object { PlantC translate <2,0,-2> }
  object { PlantD translate <-2,0,0> }
  object { PlantE translate <-2,0,2> }
  object { PlantF translate <-2,0,-2> }
  object { PlantG translate <0,0,2> }
  object { PlantH translate <0,0,-2> }
  object { PlantI translate <0,0,0> }

}

#declare SpotWeild = texture {
pigment { 
        onion
        color_map {
          [0.0 color rgb<.9,.5,.2> ]
          [0.6 color rgb<.1,.2,.3> ]          
          [0.68 color rgb<.8,.8,1> ]
          [0.7 color rgb<.1,.2,.4> ]
          [1.0 color rgb<.9,.3,.2> ]
        }
        turbulence .29
        rotate <0,20,0>
      scale <.14,.12,.16>
      }
}

#declare Spot_Moon = difference {
    cone { 
      <.34,0,-.0175>, .45
      <.34,0,.0175>, .45
      texture {
        SpotWeild
      }
    scale <2,1,1>
    }
    cone { 
      <.45,0,-.01752>, .43
      <.45,0,.01752>, .43
      texture {SpotWeild}
      scale <1.9,1,1>
    }
  }
  
#declare Spot_Marker = union {
  
  object {Spot_Moon rotate <0,90,0> translate <0,2,0> }
  object {Spot_Moon rotate <0,0,0> translate <0,2,0> }
  object {Spot_Moon rotate <0,180,0> translate <0,2,0> }
  object {Spot_Moon rotate <0,270,0> translate <0,2,0> }
  
  
  cone {
    <0,2.6,0>,.001
    <0,1.55,0>,.03
    texture {SpotWeild}
  }
  cone {
    <0,1.55,0>,.03
    <0,.5,0>,.06
    texture {SpotWeild}
  }
  cone {
    <0,.5,0>,.06
    <0,0,0>,.1
    texture {SpotWeild}
  }
  sphere {<-1,0,6>,.3
  pigment {Green filter .5 }
  }
 light_source {
    <0, 2.75, 0>
    color White
    spotlight
    radius 15
    falloff 40
    tightness 40
    point_at <0, 0, 0>
  }
}

#declare OceanBox = union {
  box {
    <.5,1,.5>
    <-.5,0,-.5>
    texture {
      pigment { color rgb<.2,.3,.9> filter .8 }
      normal { waves scale <3,3,4>    
    }
    }
  hollow
  }
  cone {
    <-.5,1,.5>,.01
    <-.5,1,-.5>,.01
    texture {T_Stone12}
  }
  cone {
    <-.5,1,-.5>,.01
    <.5,1,-.5>,.01
    texture {T_Stone12}
  }
  cone {
    <.5,1,-.5>,.01
    <.5,1,.5>,.01
    texture {T_Stone12}
  }
  cone {
    <.5,1,.5>,.01
    <-.5,1,.5>,.01
    texture {T_Stone12}
  }
  cone {
    <-.5,0,.5>,.01
    <-.5,0,-.5>,.01
    texture {T_Stone12}
  }
  cone {
    <-.5,0,-.5>,.01
    <.5,0,-.5>,.01
    texture {T_Stone12}
  }
  cone {
    <.5,0,-.5>,.01
    <.5,0,.5>,.01
    texture {T_Stone12}
  }
  cone {
    <.5,0,.5>,.01
    <-.5,0,.5>,.01
    texture {T_Stone12}
  }
}

#declare MarkerSpin = union {
object { Spot_Marker scale <4,4,4> }
object { Spot_Marker scale <4,4,4> translate <14.75,0,0> rotate <0,45,0> }
object { Spot_Marker scale <4,4,4> translate <18.5,0,0> rotate <0,90,0> }
object { Spot_Marker scale <4,4,4> translate <22.25,0,0> rotate <0,135,0> }
object { Spot_Marker scale <4,4,4> translate <24,0,0> rotate <0,180,0> }
object { Spot_Marker scale <4,4,4> translate <38.75,0,0> rotate <0,225,0> }
object { Spot_Marker scale <4,4,4> translate <34.5,0,0> rotate <0,270,0> }
object { Spot_Marker scale <4,4,4> translate <48.25,0,0> rotate <0,315,0> }
}

#declare MarkerSwirl = union {
object { MarkerSpin }
object { MarkerSpin translate <10,0,0> rotate <0,45,0> }
object { MarkerSpin translate <20,0,0> rotate <0,90,0> }
object { MarkerSpin translate <30,0,0> rotate <0,135,0> }
object { MarkerSpin translate <40,0,0> rotate <0,180,0> }
object { MarkerSpin translate <50,0,0> rotate <0,225,0> }
object { MarkerSpin translate <60,0,0> rotate <0,270,0> }
object { MarkerSpin translate <70,0,0> rotate <0,315,0> }
}

#declare AusiesWingSegment0 = union {
  merge {
  prism {
    conic_sweep
    linear_spline
    0, // sweep the following shape from here ...
    1, // ... up through here
    3, // the number of points making up the shape ...
    <1,0>, <0,5>, <0,-7.5>//, <1,0>
    texture {
      pigment {color rgb<.1,.7,.6>}
      finish {ambient .5}
    }
  rotate z*180
  scale y*.06
  }
  prism {
    conic_sweep
    linear_spline
    0, // sweep the following shape from here ...
    1, // ... up through here
    3, // the number of points making up the shape ...
    <1,0>, <0,5>, <0,-7.5>//, <1,0>
    texture {
      pigment {color rgb<.1,.6,.9>}
      finish {ambient .5}
    }
    translate y*-2
  scale y*.06
  }
  prism {
    conic_sweep
    linear_spline
    0, // sweep the following shape from here ...
    1, // ... up through here
    3, // the number of points making up the shape ...
    <-1,0>, <0,5>, <0,-7.5>//, <1,0>
    texture {
      pigment {color rgb<.2,.7,.6>}
      finish {ambient .5}
    }    
  rotate z*180
  scale y*.06
  }
  prism {
    conic_sweep
    linear_spline
    0, // sweep the following shape from here ...
    1, // ... up through here
    3, // the number of points making up the shape ...
    <-1,0>, <0,5>, <0,-7.5>//, <1,0>
    texture {
      pigment {color rgb<.2,.6,.9>}
      finish {ambient .5}
    }
    translate y*-2
  scale y*.06
  }
  }

}

#declare AusiesWingSegment2 = union {
  merge {
  prism {
    conic_sweep
    linear_spline
    0, // sweep the following shape from here ...
    1, // ... up through here
    3, // the number of points making up the shape ...
    <-1,0>, <0,5>, <0,-7.5>//, <1,0>
    texture {
      pigment {color rgb<.1,.7,.6>}
      finish {ambient .5}
    }
  rotate z*180
  scale y*.06
  }
  prism {
    conic_sweep
    linear_spline
    0, // sweep the following shape from here ...
    1, // ... up through here
    3, // the number of points making up the shape ...
    <-1,0>, <0,5>, <0,-7.5>//, <1,0>
    texture {  
      pigment {color rgb<.1,.6,.9>}
      finish {ambient .5}
    }
    translate y*-2
  scale y*.06
  }
  prism {
    conic_sweep
    linear_spline
    0, // sweep the following shape from here ...
    1, // ... up through here
    3, // the number of points making up the shape ...
    <1,0>, <0,5>, <0,-7.5>//, <1,0>
    texture {
      pigment {color rgb<.2,.7,.6>}
      finish {ambient .5}
    }
  rotate z*180
  scale y*.06
  }
  prism {
    conic_sweep
    linear_spline
    0, // sweep the following shape from here ...
    1, // ... up through here
    3, // the number of points making up the shape ...
    <1,0>, <0,5>, <0,-7.5>//, <1,0>
    texture {
      pigment {color rgb<.2,.6,.9>}
      finish {ambient .5}
    }
    translate y*-2
  scale y*.06
  }
  }

}

#declare AusiesLeftWing = union {
  object {AusiesWingSegment0 scale <1,1,1> translate <0,0,0> rotate <0,0,20+crick1*1> rotate <0,0,0> }
  object {AusiesWingSegment0 scale <1.1,1,.95> translate <-.6,0,0> rotate <0,0,20+crick1*2> rotate <0,-3,0> }
  object {AusiesWingSegment0 scale <1.2,1,.9> translate <-1.2,0,0> rotate <0,0,20+crick1*3> rotate <0,-6,0> }
  object {AusiesWingSegment0 scale <1.3,1,.85> translate <-1.8,0,0> rotate <0,0,20+crick1*4> rotate <0,-9,0> }
  object {AusiesWingSegment0 scale <1.4,1,.8> translate <-2.4,0,0> rotate <0,0,20+crick1*5> rotate <0,-12,0> }
  object {AusiesWingSegment0 scale <1.5,1,.75> translate <-3.0,0,0> rotate <0,0,20+crick1*6> rotate <0,-15,0> }
  object {AusiesWingSegment0 scale <1.6,1,.7> translate <-3.6,0,0> rotate <0,0,20+crick1*7> rotate <0,-18,0> }
  object {AusiesWingSegment0 scale <1.7,1,.65> translate <-4.2,0,0> rotate <0,0,20+crick1*8> rotate <0,-21,0> }
  object {AusiesWingSegment0 scale <1.8,1,.6> translate <-4.8,0,0> rotate <0,0,20+crick1*9> rotate <0,-24,0> }
  object {AusiesWingSegment0 scale <1.9,1,.55> translate <-5.4,0,0> rotate <0,0,20+crick1*10> rotate <0,-27,0> }
  object {AusiesWingSegment0 scale <2.0,1,.5> translate <-6.0,0,0> rotate <0,0,20+crick1*11> rotate <0,-30,0> }
  object {AusiesWingSegment0 scale <2.1,1,.45> translate <-6.6,0,0> rotate <0,0,20+crick1*12> rotate <0,-33,0> }
  object {AusiesWingSegment0 scale <2.2,1,.4> translate <-7.2,0,0> rotate <0,0,20+crick1*13> rotate <0,-36,0> }
  object {AusiesWingSegment0 scale <2.3,1,.35> translate <-7.8,0,0> rotate <0,0,20+crick1*14> rotate <0,-39,0> }
  object {AusiesWingSegment0 scale <2.4,1,.3> translate <-8.4,0,0> rotate <0,0,20+crick1*15> rotate <0,-42,0> }
  object {AusiesWingSegment0 scale <2.5,1,.25> translate <-9.0,0,0> rotate <0,0,20+crick1*16> rotate <0,-45,0> }
  object {AusiesWingSegment0 scale <2.6,1,.2> translate <-9.6,0,0> rotate <0,0,20+crick1*17> rotate <0,-48,0> }
  object {AusiesWingSegment0 scale <2.7,1,.15> translate <-10.2,0,0> rotate <0,0,20+crick1*18> rotate <0,-52,0> }
  object {AusiesWingSegment0 scale <2.8,1,.1> translate <-10.8,0,0> rotate <0,0,20+crick1*19> rotate <0,-55,0> }
  object {AusiesWingSegment0 scale <2.9,1,.05> translate <-11.4,0,0> rotate <0,0,20+crick1*20> rotate <0,-58,0> }
  object {AusiesWingSegment0 scale <3.1,1,.02> translate <-12.0,0,0> rotate <0,0,20+crick1*21> rotate <0,-61,0> }
  object {AusiesWingSegment0 scale <3.2,1,.01> translate <-12.6,0,0> rotate <0,0,20+crick1*22> rotate <0,-64,0> }
}
#declare AusiesRightWing = union {
  object {AusiesWingSegment0 scale <1,1,1> translate <0,0,0> rotate <0,0,-20-crick*1> rotate <0,0,0> }
  object {AusiesWingSegment0 scale <1.1,1,.95> translate <.6,0,0> rotate <0,0,-20-crick1*2> rotate <0,3,0> }
  object {AusiesWingSegment0 scale <1.2,1,.9> translate <1.2,0,0> rotate <0,0,-20-crick1*3> rotate <0,6,0> }
  object {AusiesWingSegment0 scale <1.3,1,.85> translate <1.8,0,0> rotate <0,0,-20-crick1*4> rotate <0,9,0> }
  object {AusiesWingSegment0 scale <1.4,1,.8> translate <2.4,0,0> rotate <0,0,-20-crick1*5> rotate <0,12,0> }
  object {AusiesWingSegment0 scale <1.5,1,.75> translate <3.0,0,0> rotate <0,0,-20-crick1*6> rotate <0,15,0> }
  object {AusiesWingSegment0 scale <1.6,1,.7> translate <3.6,0,0> rotate <0,0,-20-crick1*7> rotate <0,18,0> }
  object {AusiesWingSegment0 scale <1.7,1,.65> translate <4.2,0,0> rotate <0,0,-20-crick1*8> rotate <0,21,0> }
  object {AusiesWingSegment0 scale <1.8,1,.6> translate <4.8,0,0> rotate <0,0,-20-crick1*9> rotate <0,24,0> }
  object {AusiesWingSegment0 scale <1.9,1,.55> translate <5.4,0,0> rotate <0,0,-20-crick1*10> rotate <0,27,0> }
  object {AusiesWingSegment0 scale <2.0,1,.5> translate <6.0,0,0> rotate <0,0,-20-crick1*11> rotate <0,30,0> }
  object {AusiesWingSegment0 scale <2.1,1,.45> translate <6.6,0,0> rotate <0,0,-20-crick1*12> rotate <0,33,0> }
  object {AusiesWingSegment0 scale <2.2,1,.4> translate <7.2,0,0> rotate <0,0,-20-crick1*13> rotate <0,36,0> }
  object {AusiesWingSegment0 scale <2.3,1,.35> translate <7.8,0,0> rotate <0,0,-20-crick1*14> rotate <0,39,0> }
  object {AusiesWingSegment0 scale <2.4,1,.3> translate <8.4,0,0> rotate <0,0,-20-crick1*15> rotate <0,42,0> }
  object {AusiesWingSegment0 scale <2.5,1,.25> translate <9.0,0,0> rotate <0,0,-20-crick1*16> rotate <0,45,0> }
  object {AusiesWingSegment0 scale <2.6,1,.2> translate <9.6,0,0> rotate <0,0,-20-crick1*17> rotate <0,48,0> }
  object {AusiesWingSegment0 scale <2.7,1,.15> translate <10.2,0,0> rotate <0,0,-20-crick1*18> rotate <0,52,0> }
  object {AusiesWingSegment0 scale <2.8,1,.1> translate <10.8,0,0> rotate <0,0,-20-crick1*19> rotate <0,55,0> }
  object {AusiesWingSegment0 scale <2.9,1,.05> translate <11.4,0,0> rotate <0,0,-20-crick1*20> rotate <0,58,0> }
  object {AusiesWingSegment0 scale <3.1,1,.02> translate <12.0,0,0> rotate <0,0,-20-crick1*21> rotate <0,61,0> }
  object {AusiesWingSegment0 scale <3.2,1,.01> translate <12.6,0,0> rotate <0,0,-20-crick1*22> rotate <0,64,0> }
}

#declare AusiesTail = blob {
  threshold .01
  cylinder { <0,0,2>, <0,0,-3>, 1.5, 3.9 rotate x*-0*crick translate z*-0 rotate x*-0*crick pigment {color rgb<.2,.6,.9> }}
  cylinder { <0,0,2>, <0,0,-3>, 1.45, 3.9 rotate x*-1*crick translate z*-1 rotate x*-1*crick pigment {color rgb<.3,.6,.9> }}
  cylinder { <0,0,2>, <0,0,-3>, 1.4, 3.9 rotate x*-2*crick translate z*-2 rotate x*-2*crick pigment {color rgb<.3,.7,.8> }}
  cylinder { <0,0,2>, <0,0,-3>, 1.35, 3.9 rotate x*-3*crick translate z*-3 rotate x*-3*crick pigment {color rgb<.4,.7,.8> }}
  cylinder { <0,0,2>, <0,0,-3>, 1.3, 3.9 rotate x*-4*crick translate z*-4 rotate x*-4*crick pigment {color rgb<.4,.8,.7> }}
  cylinder { <0,0,2>, <0,0,-3>, 1.25, 3.9 rotate x*-5*crick translate z*-5 rotate x*-5*crick pigment {color rgb<.5,.8,.7> }}
  cylinder { <0,0,2>, <0,0,-3>, 1.2, 3.9 rotate x*-6*crick translate z*-6 rotate x*-6*crick pigment {color rgb<.5,.9,.6> }}
  cylinder { <0,0,2>, <0,0,-3>, 1.15, 3.9 rotate x*-7*crick translate z*-7 rotate x*-7*crick pigment {color rgb<.6,.9,.6> }}
  cylinder { <0,0,2>, <0,0,-3>, 1.1, 3.9 rotate x*-8*crick translate z*-8 rotate x*-8*crick pigment {color rgb<.6,1,.5> }}
  cylinder { <0,0,2>, <0,0,-3>, 1.05, 3.9 rotate x*-9*crick translate z*-9 rotate x*-9*crick pigment {color rgb<.7,1,.5> }}
  cylinder { <0,0,2>, <0,0,-3>, 1, 3.9 rotate x*-10*crick translate z*-10 rotate x*-10*crick pigment {color rgb<.7,.9,.4> }}
  cylinder { <0,0,2>, <0,0,-3>, .95, 3.9 rotate x*-11*crick translate z*-11 rotate x*-11*crick pigment {color rgb<.8,1,.4> }}
  cylinder { <0,0,2>, <0,0,-3>, .9, 3.9 rotate x*-12*crick translate z*-12 rotate x*-12*crick pigment {color rgb<.8,.9,.3> }}
  cylinder { <0,0,2>, <0,0,-3>, .85, 3.9 rotate x*-13*crick translate z*-13 rotate x*-13*crick pigment {color rgb<.9,1,.3> }}
  cylinder { <0,0,2>, <0,0,-3>, .8, 3.9 rotate x*-14*crick translate z*-14 rotate x*-14*crick pigment {color rgb<.9,.8,.2> }}
  cylinder { <0,0,2>, <0,0,-3>, .75, 3.9 rotate x*-15*crick translate z*-15 rotate x*-15*crick pigment {color rgb<1,1,.2> }}
  cylinder { <0,0,2>, <0,0,-3>, .7, 3.9 rotate x*-16*crick translate z*-16 rotate x*-16*crick pigment {color rgb<1,.8,.1> }}
  cylinder { <0,0,2>, <0,0,-3>, .65, 3.9 rotate x*-17*crick translate z*-17 rotate x*-17*crick pigment {color rgb<.9,1,.1> }}
  cylinder { <0,0,2>, <0,0,-3>, .6, 3.9 rotate x*-18*crick translate z*-18 rotate x*-18*crick pigment {color rgb<.9,.7,0> }}
  cylinder { <0,0,2>, <0,0,-3>, .55, 3.9 rotate x*-19*crick translate z*-19 rotate x*-19*crick pigment {color rgb<.9,1,0> }}
  cylinder { <0,0,2>, <0,0,-3>, .5, 3.9 rotate x*-20*crick translate z*-20 rotate x*-20*crick pigment {color rgb<.9,.7,0> }}
  cylinder { <0,0,2>, <0,0,-3>, .45, 3.9 rotate x*-21*crick translate z*-21 rotate x*-21*crick pigment {color rgb<.8,1,.1> }}
  cylinder { <0,0,2>, <0,0,-3>, .4, 3.9 rotate x*-22*crick translate z*-22 rotate x*-22*crick pigment {color rgb<.7,.6,0> }}
  cylinder { <0,0,2>, <0,0,-3>, .35, 3.9 rotate x*-23*crick translate z*-23 rotate x*-23*crick pigment {color rgb<.6,.9,.2> }}
  cylinder { <0,0,2>, <0,0,-3>, .3, 3.9 rotate x*-24*crick translate z*-24 rotate x*-24*crick pigment {color rgb<.5,.6,0> }}
  cylinder { <0,0,2>, <0,0,-3>, .25, 3.9 rotate x*-25*crick translate z*-25 rotate x*-25*crick pigment {color rgb<.4,.9,.3> }}
  cylinder { <0,0,2>, <0,0,-3>, .2, 3.9 rotate x*-26*crick translate z*-26 rotate x*-26*crick pigment {color rgb<.3,.5,0> }}
  cylinder { <0,0,2>, <0,0,-3>, .15, 3.9 rotate x*-27*crick translate z*-27 rotate x*-27*crick pigment {color rgb<.2,.9,.4> }}
  cylinder { <0,0,2>, <0,0,-3>, .1, 3.9 rotate x*-28*crick translate z*-28 rotate x*-28*crick pigment {color rgb<.1,.5,0> }}
  cylinder { <0,0,2>, <0,0,-3>, .05, 3.9 rotate x*-29*crick translate z*-29 rotate x*-29*crick pigment {color rgb<0,.8,.5> }}
  cylinder { <0,0,2>, <0,0,-3>, .05, 3.9 rotate x*-30*crick translate z*-30 rotate x*-30*crick pigment {color rgb<0,.5,0> }}
  finish { phong .1 }
}

#declare AusiesEar = prism {
  linear_sweep
  cubic_spline
  0, // sweep the following shape from here ...
  1, // ... up through here
  14, // the number of points making up the shape ...
  <-1,1>,<5,4>,<2,3>, <0,1>, <1,0>, <2,1>, <2,0>,<1,-1>, <-1,-1>, <-2,0>, <-2,1>, <0,3>,<5,4>,<-6,-1>
    pigment {color rgb<.8,.9,1>}
   scale y*.1
  rotate z*0 rotate x*-90 rotate y*90
}

#declare AusiesNeck = blob {
  threshold .01
  sphere { <0,0,0>, 1.5, 3.9 rotate x*crick*-1 pigment {color rgb<.2,.6,.9> }}
  sphere { <0,0,.25>, 1.5, 3.9 rotate x*crick*-1.1 pigment {color rgb<.3,.6,.9> }}
  sphere { <0,0,.5>, 1.5, 3.9 rotate x*crick*-1.3 pigment {color rgb<.3,.7,.8> }}
  sphere { <0,0,.75>, 1.4, 3.9 rotate x*crick*-1.6 pigment {color rgb<.2,.6,.9> }}
  sphere { <0,0,1>, 1.4, 3.9 rotate x*crick*-2 pigment {color rgb<.3,.6,.9> }}
  sphere { <0,0,1.25>, 1.4, 3.9 rotate x*crick*-2.5 pigment {color rgb<.3,.7,.8> }}
  sphere { <0,0,1.5>, 1.35, 3.9 rotate x*crick*-3.1 pigment {color rgb<.2,.6,.9> }}
  sphere { <0,0,1.75>, 1.35, 3.9 rotate x*crick*-3.8 pigment {color rgb<.3,.6,.9> }}
  sphere { <0,0,2>, 1.35, 3.9 rotate x*crick*-4.7 pigment {color rgb<.3,.7,.8> }}
  sphere { <0,0,2.25>, 1.4, 3.9 rotate x*crick*-5.7 pigment {color rgb<.2,.6,.9> }}
  sphere { <0,0,2.5>, 1.4, 3.9 rotate x*crick*-6.8 pigment {color rgb<.3,.6,.9> }}
  sphere { <0,0,2.75>, 1.4, 3.9 rotate x*crick*-7.9 pigment {color rgb<.3,.7,.8> }}
  sphere { <0,0,3>, 1.45, 3.9 rotate x*crick*-9 pigment {color rgb<.2,.6,.9> }}
  sphere { <0,0,3.25>, 1.45, 3.9 rotate x*crick*-10.2 pigment {color rgb<.3,.6,.9> }}
  sphere { <0,0,3.5>, 1.45, 3.9 rotate x*crick*-11.5 pigment {color rgb<.3,.7,.8> }}
  sphere { <0,0,3.75>, 1.4, 3.9 rotate x*crick*-12.9 pigment {color rgb<.2,.6,.9> }}
  sphere { <0,0,4>, 1.45, 3.9 rotate x*crick*-14.4 pigment {color rgb<.3,.6,.9> }}
  sphere { <0,0,4.25>, 1.35, 3.9 rotate x*crick*-15 pigment {color rgb<.3,.7,.8> }}
  sphere { <0,0,4.5>, 1.4, 3.9 rotate x*crick*-14.9 pigment {color rgb<.2,.6,.9> }}
  sphere { <0,0,4.75>, 1.5, 3.9 rotate x*crick*-14.8 pigment {color rgb<.3,.6,.9> }}
  sphere { <0,0,5>, 1.5, 3.9 rotate x*crick*-14.7 pigment {color rgb<.3,.7,.8> }}
  sphere { <0,0,5.25>, 1.4, 3.9 rotate x*crick*-14.6 pigment {color rgb<.2,.6,.9> }}
  sphere { <0,0,5.5>, 1.4, 3.9 rotate x*crick*-14.5 pigment {color rgb<.3,.6,.9> }}
  sphere { <0,0,5.75>, 1.4, 3.9 rotate x*crick*-14.4 pigment {color rgb<.3,.7,.8> }}
  sphere { <0,0,6>, 1.35, 3.9 rotate x*crick*-14.3 pigment {color rgb<.2,.6,.9> }}
  sphere { <0,0,6.25>, 1.35, 3.9 rotate x*crick*-14.2 pigment {color rgb<.3,.6,.9> }}
  sphere { <0,0,6.5>, 1.35, 3.9 rotate x*crick*-14 pigment {color rgb<.3,.7,.8> }}
}

#declare AusiesEye = difference {
  intersection {
    cone {
      <0,0,1.25>,0
      <0,0,-1>,.75
      pigment {color rgb<crick,crick/4,crick/2>}
    }
    sphere {
      <0,0,0>,.55
      pigment {color rgb<crick,crick/4,crick/2>}
      scale <.6,1,1>
    }
  }
  sphere {
    <0,0,-.8>,.2
    pigment {color rgb<crick,crick/4,crick/2>}
  }
}

#declare AusiesBeak = union {
  blob {
    threshold .01
    sphere { <0,0,6.75-.1*crick>, 1.4, 3.9 rotate x*crick*-13 pigment {color rgb<.5,.8,.9> }}
    sphere { <0,0,7.0-.1*crick*2>, 1.5, 3.9 rotate x*crick*-12 pigment {color rgb<.6,.7,.8> }}
    sphere { <0,0,7.25-.1*crick*3>, 1.6, 3.9 rotate x*crick*-10 pigment {color rgb<.7,.6,.7> }}
    sphere { <0,0,7.5-.1*crick*4>, 1.7, 3.9 rotate x*crick*-7 pigment {color rgb<.8,.5,.6> }}
    sphere { <0,0,7.75-.1*crick*5>, 1.6, 3.9 rotate x*crick*-4 pigment {color rgb<.5,.8,.9> }}
    sphere { <0,0,8-.1*crick*6>, 1.5, 3.9 rotate x*crick*0 pigment {color rgb<.6,.7,.8> }}
    sphere { <0,0,8.25-.1*crick*7>, 1.4, 3.9 rotate x*crick*2 pigment {color rgb<.7,.6,.7> }}
    sphere { <0,0,8.5-.1*crick*8>, 1.3, 3.9 rotate x*crick*5 pigment {color rgb<.8,.5,.6> }}
  }
  object {AusiesEye scale <1.5,1.5,1.5> rotate <10+crick*30,0,0> translate <1.3,.4,8-.1*crick*6> rotate <-3+crick*-5,0,0>}
  object {AusiesEye scale <1.5,1.5,1.5> rotate <10+crick*30,0,0> translate <-1.3,.4,8-.1*crick*6> rotate <-3+crick*-5,0,0>}
  difference {
    intersection {
      sphere {
        <0,0,0>,3
        texture {T_Stone12}  
      }
      sphere {
        <0,1.25,1.25>,3
        texture {T_Stone12}  
      }
    }
    sphere {
      <0,-.75,-.5>,3
      texture {T_Stone12}  
    }
  scale <.6,.5,.9>
  rotate <295+crick*-40,180,0>
  translate <0,-1.05,9-.1*crick*14>
  rotate x*crick*0
  }
  difference {
    intersection {
      sphere {
        <0,0,0>,3
        texture {T_Stone12}  
      }
      sphere {
        <0,1.25,1.25>,3
        texture {T_Stone12}  
      }
    }
    sphere {
      <0,-.75,-.5>,3
      texture {T_Stone12}  
    }
  scale <.6,.45,.9>
  rotate <crick*90+crick*-40,180,180>
  translate <0,-.6,9-.1*crick*13>
  rotate x*crick*0
  }
}  
  
#declare AusiesHead = union {
  object {AusiesEar scale <.6,.6,.6> rotate x*-14*crick translate <1.5,-1.25,5.5> rotate x*-14*crick}
  object {AusiesEar scale <.6,.6,.6> rotate x*-14*crick translate <-1.5,-1.25,5.5> rotate x*-14*crick }
  object {AusiesNeck translate <0,-1.3,0>}
  object {AusiesBeak translate <0,-1.3,0>}
  
}

#declare Ausie = union {
  object {AusiesLeftWing rotate y*-7 translate x*-.5}
  object {AusiesRightWing rotate y*7 translate x*.5}
  object {AusiesTail translate y*-1.3}
  object {AusiesHead translate z*2}
}

#declare AirBubble = sphere {
  <0,0,0>,.3
  texture {
    pigment {
      color rgbt<.8,.8,.8,.8>
    }
    finish {phong .8
    diffuse .9 }
  }
}

#declare AirStorm = merge {
  object {AirBubble translate <20,0,0> rotate <0,60,0> scale <5,5,5>}
  object {AirBubble translate <18,0,1> rotate <0,20,0> scale <5,5,5>}
  object {AirBubble translate <16,0,2> rotate <0,30,0> scale <5,5,5>}
  object {AirBubble translate <14,0,3> rotate <0,40,0> scale <5,5,5>}
  object {AirBubble translate <12,0,4> rotate <0,150,0> scale <5,5,5>}
  object {AirBubble translate <10,0,5> rotate <0,60,0> scale <5,5,5>}
  object {AirBubble translate <8,0,6> rotate <0,150,0> scale <5,5,5>}
  object {AirBubble translate <6,0,7> rotate <0,80,0> scale <5,5,5>}
  object {AirBubble translate <4,0,8> rotate <0,290,0> scale <5,5,5>}
  object {AirBubble translate <2,0,9> rotate <0,110,0> scale <5,5,5>}
  object {AirBubble translate <0,0,10> rotate <0,20,0> scale <5,5,5>}
}

#declare AirSwift = merge {
  /*object {AirStorm translate <0,0,0> rotate <10,10,10> }
  object {AirStorm translate <10,0,0> rotate <20,15,11>}
  object {AirStorm translate <10,10,0> rotate <30,20,12>}
  object {AirStorm translate <10,10,10> rotate <40,25,13>}
  object {AirStorm translate <20,10,10> rotate <50,30,14>}
  object {AirStorm translate <20,20,10> rotate <60,35,15>}
  object {AirStorm translate <20,20,20> rotate <70,40,16>}
  object {AirStorm translate <30,20,20> rotate <80,45,17>}
  object {AirStorm translate <30,30,20> rotate <90,50,18>}
  object {AirStorm translate <30,30,30> rotate <100,55,19>}
  object {AirStorm translate <40,30,30> rotate <110,60,20>}
  object {AirStorm translate <40,40,30> rotate <120,65,21>}
  object {AirStorm translate <40,40,40> rotate <130,70,22>}
  object {AirStorm translate <50,40,40> rotate <140,75,23>}*/
  object {AirStorm translate <50,50,40> rotate <150,80,24>}
  object {AirStorm translate <50,50,50> rotate <160,85,25>}
  object {AirStorm translate <60,50,50> rotate <170,90,26>}
  object {AirStorm translate <60,60,50> rotate <180,95,27>}
  object {AirStorm translate <60,60,60> rotate <190,100,28>}
}

#declare AirSphere = merge {
  object {AirSwift translate <20,1,0> rotate <10,0,0>}
  object {AirSwift translate <40,2,0> rotate <30,0,0>}
  object {AirSwift translate <80,3,0> rotate <50,0,0>}
  object {AirSwift translate <70,4,0> rotate <70,0,0>}
  object {AirSwift translate <50,5,0> rotate <90,0,0>}
  object {AirSwift translate <80,6,0> rotate <110,0,0>}
  object {AirSwift translate <90,7,0> rotate <130,0,0>}
}

#declare TheMetricOcean =intersection {
  object { OceanBox scale <200,50,200> translate <-175,-12,-175> }
  object { AirSphere rotate <50,125,60> scale <1.25,1.25,1.25> translate <-125,-3,-75> }
}